IF not EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO]') 
					AND type in (N'U')) 
BEGIN
	CREATE TABLE [dbo].[PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO](
		[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_FORN] [int] NOT NULL,
		[CD_INT] [int] NOT NULL,
		[NOME] [varchar](150) NOT NULL,
		[EMAIL] [varchar](150) NOT NULL,
		[ATIVO] [bit] NOT NULL CONSTRAINT [DF_PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO_ATIVO]  DEFAULT ((1)),
	 CONSTRAINT [PK_PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	SET ANSI_PADDING OFF
	ALTER TABLE [dbo].[PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO_PG_FORN_INTEGRACAO] FOREIGN KEY([CD_EMP], [CD_FORN], [CD_INT])
	REFERENCES [dbo].[PG_FORN_INTEGRACAO] ([CD_EMP], [CD_FORN], [CD_INT])
 	ALTER TABLE [dbo].[PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO] CHECK CONSTRAINT [FK_PG_FORN_INTEGRACAO_EMAIL_NOTIFICACAO_PG_FORN_INTEGRACAO]
END
GO
